-- BTR-4 by Currenthill

-- Chassis
GT_t.CH_t.BTR4 = {
	life = 4,
	mass = 20500,
	length = 7.76,
	width = 2.93,
	max_road_velocity = 30.55,
	max_slope = 0.6,
	fordingDepth = 1.4,
	canSwim = true,	
	max_vert_obstacle = 1,
	waterline_level = 1.4,	
	max_acceleration = 1.8,
	min_turn_radius = 13.0,
	engine_power = 598,
	engineMinRPM = 700,
	engineMaxPowerRPM = 2200,
	engineMaxRPM = 2600,
	gearRatios = { -5.03, 0.0, 3.49, 1.86, 1.41, 1.00, 0.75, 0.65},
	mainGearRatio = 5.2,
	automaticTransmission = true,	
	X_gear_1 = 2.199,
	Y_gear_1 = 0,
	Z_gear_1 = 1.319,
	X_gear_2 = -2.15,
	Y_gear_2 = 0,
	Z_gear_2 = 1.319,		
	gear_type = GT_t.GEAR_TYPES.WHEELS,
	r_max = 0.54,
	armour_thickness = 0.015,
}

GT = {};
GT_t.ws = 0;
set_recursive_metatable(GT, GT_t.generic_wheel_IFV);
set_recursive_metatable(GT.chassis, GT_t.CH_t.BTR4);

GT.visual.shape = "BTR-4";
GT.visual.shape_dstr = "BTR-4-dest";

GT.toggle_alarm_state_interval = 1.0;

GT.DM = {
    { area_name = "CANNON",             armour = {width=0.050}},
    { area_name = "GUN_MASK",           armour = {width=0.030}},

    { area_name = "TURRET_FRONT",       armour = {width=0.040}},
    { area_name = "TURRET_BACK",        armour = {width=0.020}},
    { area_name = "TURRET_LEFT",        armour = {width=0.040}},
    { area_name = "TURRET_RIGHT",       armour = {width=0.040}},
    { area_name = "TURRET_TOP",         armour = {width=0.030}},

    { area_name = "BODY",               armour = {width=0.040}},
    { area_name = "BODY_FRONT_UP",      armour = {width=0.040}},
    { area_name = "BODY_FRONT_DOWN",    armour = {width=0.040}},
    { area_name = "BODY_LEFT",          armour = {width=0.040}},
    { area_name = "BODY_RIGHT",         armour = {width=0.040}},
    { area_name = "BODY_BACK",          armour = {width=0.020}},

    { area_name = "WHEEL_L_1",          armour = {width=0.040}},
    { area_name = "WHEEL_L_2",          armour = {width=0.040}},
    { area_name = "WHEEL_L_3",          armour = {width=0.040}},
    { area_name = "WHEEL_L_4",          armour = {width=0.040}},
    { area_name = "WHEEL_L_5",          armour = {width=0.040}},
    { area_name = "WHEEL_L_6",          armour = {width=0.040}},
    { area_name = "WHEEL_L_7",          armour = {width=0.040}},
    { area_name = "WHEEL_L_8",          armour = {width=0.040}},
    { area_name = "WHEEL_R_1",          armour = {width=0.040}},
    { area_name = "WHEEL_R_2",          armour = {width=0.040}},
    { area_name = "WHEEL_R_3",          armour = {width=0.040}},
    { area_name = "WHEEL_R_4",          armour = {width=0.040}},
    { area_name = "WHEEL_R_5",          armour = {width=0.040}},
    { area_name = "WHEEL_R_6",          armour = {width=0.040}},
    { area_name = "WHEEL_R_7",          armour = {width=0.040}},
    { area_name = "WHEEL_R_8",          armour = {width=0.040}},
}

-- Turbine
GT.turbine = false;

-- Chassis
GT.swing_on_run = false;

GT.sensor = {};
set_recursive_metatable(GT.sensor, GT_t.SN_visual);
GT.sensor.height = 3.1;

-- Burning after hit
GT.visual.fire_size = 0.8; --relative burning size
GT.visual.fire_pos[1] = 0; -- center of burn at long axis shift(meters)
GT.visual.fire_pos[2] = 0; -- center of burn shift at vertical shift(meters)
GT.visual.fire_pos[3] = 0; -- center of burn at transverse axis shift(meters)
GT.visual.fire_time = 1000; --burning time (seconds)
GT.visual.dust_pos = {1.2, 0.05, 0}
GT.visual.dirt_pos = {-1.2, 0.05, 0}

GT.driverViewConnectorName = {"POINT_DRIVER", offset = {0.05, 0.0, 0.0}}
GT.driverCockpit = "DriverCockpit/DriverCockpitWithIRandLLTV"

-- ============================= WEAPONS ==================================================================

--GT.WS[1]
GT.WS = {};
local ws;
GT.WS.maxTargetDetectionRange = 5000;
GT.WS.smoke = {"POINT_SMOKE_01", "POINT_SMOKE_02", "POINT_SMOKE_03", 
				"POINT_SMOKE_04", "POINT_SMOKE_05", "POINT_SMOKE_06"};

ws = GT_t.inc_ws();
GT.WS[ws] = {};
GT.WS[ws].center = 'CENTER_TOWER_01';
GT.WS[ws].pointer = 'POINT_SIGHT_01'
GT.WS[ws].cockpit = { "BMP-3/BMP-3_gunner", {0.0, 0.0, 0.0 }, };
GT.WS[ws].angles = {				
                    {math.rad(180), math.rad(-180), math.rad(-6), math.rad(60)},				
                    };
GT.WS[ws].drawArgument1 = 0;
GT.WS[ws].drawArgument2 = 1;
GT.WS[ws].omegaY = math.rad(40);
GT.WS[ws].omegaZ = math.rad(40);
GT.WS[ws].pidY = MODERN_TANK_TOWER_PIDY
GT.WS[ws].pidZ = MODERN_TANK_TOWER_PIDZ
GT.WS[ws].stabilizer = true;
GT.WS[ws].laser = true;

-- =========================== ZTM-1 30 mm autocannon - APFSDS-T ==========================================

--GT.WS[1].LN[1]
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.BTR4_ZTM_1);
__LN.BR[1] = {connector_name = 'POINT_GUN_01',
			recoilArgument = 23,			
			recoilTime = 60/330/2,
			case_extraction_connector 	=  'EJECTOR_1',
			shellCaseID 			= 0,
			extractionDir 			= {x = 7.0, y = 0.4, z = 0.0},
			shellCaseOrientation 	= {x = 0, y = 0, z = 0}				
			};
__LN.sightMasterMode = 1;
__LN.sightIndicationMode = 1;

-- =========================== ZTM-1 30 mm autocannon - HE-T ==============================================

--GT.WS[1].LN[2]
__LN = add_launcher(GT.WS[ws], __LN);
__LN.type = 3;
__LN.distanceMin = 10;
__LN.distanceMax = 3000;
__LN.max_trg_alt = 2000;
__LN.PL[1].shell_name = {"BTR4_HEI"};
__LN.PL[1].ammo_capacity = 200;
__LN.PL[1].shot_delay = 60/330
__LN.sightMasterMode = 1;
__LN.sightIndicationMode = 1;

-- =========================== KT-7.62 machine gun ========================================================

-- GT.WS[1].LN[3]
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.BTR4_KT);
__LN.secondary = true;
__LN.BR[1] = { connector_name = 'POINT_GUN_02', 
							recoilArgument = 50,
							recoilTime = 60/650/2 }		

-- =========================== AGS-17 automatic grenade launcher ==========================================

-- GT.WS[1].LN[4]
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.BTR4_AG17);
__LN.BR[1] = { connector_name = 'POINT_GUN_03', 
							recoilArgument = 27,
							recoilTime = 60/400/2 }
__LN.sightMasterMode = 1;
__LN.sightIndicationMode = 3;

-- ============================ RK-2 Barrier ATGM  ========================================================

__LN = add_launcher(GT.WS[ws], GT_t.LN_t.BTR4_RK2_Barrier)
__LN.BR[1] = {connector_name = 'POINT_MISSILE_01', drawArgument = 24}
__LN.BR[2] = {connector_name = 'POINT_MISSILE_02', drawArgument = 25}
__LN.type = 33
__LN.distanceMin = 150
__LN.distanceMax = 5000
__LN.max_trg_alt = 1500
__LN.reactionTime = 0.5;
__LN.launch_delay = 2;
__LN.beamWidth = math.rad(0);
__LN.radialDisperse = 0.0;
__LN.dispertionReductionFactor = 0.999;
__LN.missileControlInterval = 0.01;
__LN.maxShootingSpeed = 0;
__LN.PL[1].type_ammunition = RK_2_BARRIER.wsTypeOfWeapon;
__LN.PL[1].automaticLoader = false;
__LN.PL[1].shot_delay = 2.0;
__LN.PL[1].ammo_capacity = 2;
__LN.PL[1].reload_time = 2;
__LN.inclination_correction_upper_limit = math.rad(90);		
__LN.inclination_correction_bias = math.rad(1.1);
__LN.sightMasterMode = 1;
__LN.sightIndicationMode = 4;

-- ========================================================================================================

GT.Name = "CH_BTR-4";
GT.DisplayName = _("[CH] BTR-4 IFV");
GT.DisplayNameShort = _('BTR-4');
GT.Rate = 12;

GT.Sensors = { 
	Mount_WS_ID = 1,
	OPTIC = {"TKN-3B day", "TKN-3B night",
                        },
	noVisualDetectorInAlarmedState = false							
            };
				
GT.EPLRS = true

GT.InternalCargo = {
    nominalCapacity = 700,
    maximalCapacity = 700,
}
				
GT.DetectionRange  = 0;
GT.airWeaponDist = 5000
GT.ThreatRange = 5000;
GT.ThreatRangeMin = 150;
GT.mapclasskey = "P0091000002";
GT.attribute = {wsType_Ground,wsType_Tank,wsType_Gun,WSTYPE_PLACEHOLDER,
				"IFV",
				"ATGM",
				"Datalink"
				};
GT.category = "Armor";

GT.tags  =
{
    "Armor",
    "IFV",
}

GT.Countries = {"Ukraine"}
